/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.managed.UserRole;
import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskContainerNode;
import com.ibm.hwmca.ui.bonsai.earth.util.UserRolePermissionsSet;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BonsaiTreeResourceNode
extends TaskContainerNode {
    private Set permittedChildrenRoles;
    private String display;

    protected BonsaiTreeResourceNode(BonsaiTreeResourceNode clonee, BonsaiTreeNode parent) {
        super(clonee, parent);
        this.display = clonee.display;
        this.permittedChildrenRoles = clonee.permittedChildrenRoles;
    }

    public BonsaiTreeResourceNode(ResourcesNodeConfigBean configBean, BonsaiTreeNode parent) {
        super(configBean, parent);
        this.permittedChildrenRoles = new HashSet();
        this.display = configBean.getDisplay();
    }

    public void addChild(BonsaiTreeNode childNode) {
        super.addChild(childNode);
        UserRole userRole = null;
        HashSet<UserRole> roleSet = null;
        BonsaiTreeResourceNode resNode = null;
        String display = null;
        Iterator iterator = UserRolePermissionsSet.getAllUserRoles().iterator();
        while (iterator.hasNext()) {
            userRole = (UserRole)iterator.next();
            if (this.permittedChildrenRoles.contains(userRole)) continue;
            if (childNode instanceof BonsaiTreeResourceNode) {
                resNode = (BonsaiTreeResourceNode)childNode;
                display = resNode.display;
                roleSet = new HashSet<UserRole>();
                roleSet.add(userRole);
                if (!resNode.isPermitted(roleSet) || !display.equalsIgnoreCase("always") && !display.equalsIgnoreCase("leaf") && (!display.equalsIgnoreCase("notempty") || !resNode.hasPermittedChildren(roleSet))) continue;
                this.permittedChildrenRoles.add(userRole);
                continue;
            }
            this.permittedChildrenRoles.add(userRole);
        }
    }

    public boolean removeChild(String id) {
        if (super.removeChild(id)) {
            boolean foundPermittedChild = false;
            UserRole userRole = null;
            HashSet<UserRole> roleSet = null;
            BonsaiTreeNode childNode = null;
            BonsaiTreeResourceNode resNode = null;
            String display = null;
            Iterator iterator = UserRolePermissionsSet.getAllUserRoles().iterator();
            while (iterator.hasNext()) {
                userRole = (UserRole)iterator.next();
                if (!this.permittedChildrenRoles.contains(userRole)) continue;
                foundPermittedChild = false;
                Iterator children = this.getChildren().iterator();
                while (children.hasNext() && !foundPermittedChild) {
                    childNode = (BonsaiTreeNode)children.next();
                    if (childNode instanceof BonsaiTreeResourceNode) {
                        resNode = (BonsaiTreeResourceNode)childNode;
                        display = resNode.display;
                        roleSet = new HashSet<UserRole>();
                        roleSet.add(userRole);
                        foundPermittedChild = resNode.isPermitted(roleSet) && (display.equalsIgnoreCase("always") || display.equalsIgnoreCase("leaf") || display.equalsIgnoreCase("notempty") && resNode.hasPermittedChildren(roleSet));
                        continue;
                    }
                    foundPermittedChild = true;
                }
                if (foundPermittedChild) continue;
                this.permittedChildrenRoles.remove(userRole);
            }
            return true;
        }
        return false;
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.permittedChildrenRoles = new HashSet();
    }

    public boolean isShown(String modelKey, UISession session) {
        Set userRoles = session.getUserRoles();
        if (modelKey.equals("navAreaTree")) {
            return !this.display.equalsIgnoreCase("never") && this.isPermitted(userRoles) && (this.display.equalsIgnoreCase("always") || this.display.equalsIgnoreCase("notempty") && this.hasPermittedChildren(userRoles));
        }
        if (modelKey.equals("workAreaTable")) {
            return !this.display.equalsIgnoreCase("never") && this.isPermitted(userRoles) && (this.display.equalsIgnoreCase("always") || this.display.equalsIgnoreCase("leaf") || this.display.equalsIgnoreCase("notempty") && this.hasPermittedChildren(userRoles));
        }
        return false;
    }

    protected boolean hasPermittedChildren(Set userRoles) {
        Iterator iterator = userRoles.iterator();
        while (iterator.hasNext()) {
            if (!this.permittedChildrenRoles.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public BonsaiTreeNode createViewNode(BonsaiTreeNode parent) {
        BonsaiTreeResourceNode view = new BonsaiTreeResourceNode(this, parent);
        view.copyChildren(this);
        return view;
    }
}

